package com.burhanstore.neonbubblequest.act

import android.app.Activity
import android.os.Bundle
import android.util.Log
import android.view.View
import androidx.appcompat.app.AppCompatActivity
import androidx.lifecycle.lifecycleScope
import androidx.recyclerview.widget.LinearLayoutManager
import com.burhanstore.neonbubblequest.Utils.DialogManager
import com.burhanstore.neonbubblequest.Utils.adapter.RedeemsAdapter
import com.burhanstore.neonbubblequest.Utils.anim.setClick
import com.burhanstore.neonbubblequest.Utils.appuser.UserManager
import com.burhanstore.neonbubblequest.Utils.model.RedeemsModel
import com.burhanstore.neonbubblequest.Utils.network.AppNetworkAdapter
import com.burhanstore.neonbubblequest.Utils.response.RedeemsResponse
import com.burhanstore.neonbubblequest.databinding.ActivityRedeemsBinding
import com.google.gson.Gson
import com.google.gson.JsonObject
import kotlinx.coroutines.launch

class RedeemsActivity : AppCompatActivity() {

    private lateinit var binding: ActivityRedeemsBinding
    private lateinit var activity: Activity

    private var uid: String = ""
    private lateinit var user_m: UserManager

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        binding = ActivityRedeemsBinding.inflate(layoutInflater)
        setContentView(binding.root)
        activity = this

        DialogManager.initDialog(activity)
        DialogManager.showDialog()
        binding.imageView2.setClick { finish() }



        user_m = UserManager.Companion.getInstance(activity)
        uid = user_m.getUser()?.u_id ?: ""



        get_data()
    }

    private fun get_data() {

        val json = JsonObject().apply {
            addProperty("action", "get_redeems")
            addProperty("u_id", uid)
        }
        AppNetworkAdapter.sendRequest(
            lifecycleScope,
            json,
            object : AppNetworkAdapter.ResponseHandler {
                override fun onSuccess(response: JsonObject?) {
                    Log.d("QuickBonus", "Success: $response")

                    lifecycleScope.launch {
                        try {
                            val quickBonusResponse =
                                Gson().fromJson(response, RedeemsResponse::class.java)
                            val trackList = quickBonusResponse.redeems ?: emptyList()
                            update_redeems(trackList)
                            DialogManager.dismissDialog()

                        } catch (e: Exception) {
                            Log.e("QuickBonus", "Parsing error: ${e.message}")
                        }
                    }
                }

                override fun onError(code: Int, message: String?) {
                    Log.e("QuickBonus", "Error $code: $message")
                }

                override fun onException(exception: Exception) {
                    Log.e("QuickBonus", "Exception: ", exception)
                }
            }
        )

    }


    private fun update_redeems(trackList: List<RedeemsModel>) {
        if (trackList.isEmpty()) {
            binding.ly2.visibility = View.VISIBLE
            return
        }

        val trackAdapter = RedeemsAdapter(this, trackList) { selectedItem ->
        }

        binding.trackList.layoutManager = LinearLayoutManager(this)
        binding.trackList.adapter = trackAdapter
        binding.trackList.visibility = View.VISIBLE
        binding.ly2.visibility = View.VISIBLE
    }


}